package com.bxm.localnews.market.facade.fallback;

import com.bxm.localnews.market.facade.UserVipFeignService;
import com.bxm.localnews.market.param.VipQueryParam;
import com.bxm.localnews.market.model.param.ActivationUserVipParam;
import com.bxm.localnews.user.model.VipInfoDetailDTO;
import feign.hystrix.FallbackFactory;
import org.springframework.http.ResponseEntity;

/**
 * 用户vip服务熔断降级
 *
 * @author wzy
 * @date 2020/8/10 23:06
 **/
public class UserVipFallbackFactory implements FallbackFactory<UserVipFeignService> {
    @Override
    public UserVipFeignService create(Throwable throwable) {
        return new UserVipFeignService() {
            @Override
            public ResponseEntity<VipInfoDetailDTO> getVipDetail(VipQueryParam param) {
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<Boolean> isVip(Long userId) {
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<Boolean> buyVip(ActivationUserVipParam param) {
                return ResponseEntity.badRequest().build();
            }
        };
    }
}
