package com.bxm.localnews.market.integration;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.market.dto.CommissionPlatformFacadeDTO;
import com.bxm.localnews.market.facade.CommodityCommissionFeignService;
import com.bxm.localnews.market.param.GetPlatformCommissionParam;
import com.bxm.newidea.component.vo.ResponseJson;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Objects;

@Slf4j
@Service
public class CommodityCommissionFacadeService {

    @Autowired
    private CommodityCommissionFeignService commodityCommissionFeignService;

    /**
     * 获取平台返佣信息
     * @param param param
     * @return 平台返佣信息
     */
    public CommissionPlatformFacadeDTO getPlatformCommission(GetPlatformCommissionParam param) {

        try {
            ResponseJson<CommissionPlatformFacadeDTO> responseJson = commodityCommissionFeignService.getPlatformCommission(param.getGoodsId(),
                    param.getCommissionPrice(), param.getPayPrice(), param.getGoodsNum(), param.getPurchaseBySelf(),
                    param.getUserId(), param.getVip(), param.getSuperiorUserId(), param.getSrcApp());

            if (Objects.nonNull(responseJson) && responseJson.success()) {
                return responseJson.getResult();
            }

        } catch(Exception e) {
            log.error("获取平台返佣信息 请求失败 param: {}", JSON.toJSONString(param), e);
        }

        return null;
    }

    /**
     * 获取商品优惠券金额
     * @param goodsId goodsId
     * @return 商品优惠券金额
     */
    public BigDecimal getCouponPrice(Long goodsId) {
        try {
            ResponseJson<Double> responseJson = commodityCommissionFeignService.getCouponPrice(goodsId);
            if (Objects.nonNull(responseJson) && responseJson.success()) {
                return BigDecimal.valueOf(responseJson.getResult());
            }

        } catch(Exception e) {
            log.error("获取商品优惠券金额 请求失败 goodsId: {}", goodsId, e);
        }

        return null;
    }
}
