package com.bxm.localnews.market.integration;

import com.bxm.localnews.market.facade.CommodityInfoFeignService;
import com.bxm.newidea.component.enums.AppNameEnum;
import com.bxm.newidea.component.vo.ResponseJson;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

@Slf4j
@Service
public class CommodityInfoFacadeService {

    @Autowired
    private CommodityInfoFeignService commodityInfoFeignService;

    /**
     * 获取淘宝联盟跳转地址
     * @return 跳转链接
     */
    public String getTaoBaoUnionStr(Long adzoneId, String relationId, Long promotionSceneId) {
        try {
            ResponseJson<String> responseJson = commodityInfoFeignService.getTaoBaoUnionStr(adzoneId,
                    relationId, promotionSceneId, Objects.toString(AppNameEnum.LOCAL_NEWS));

            if (Objects.nonNull(responseJson) && responseJson.success() && Objects.nonNull(responseJson.getResult())) {
                return responseJson.getResult();
            }

        } catch(Exception e) {
            log.error("获取淘宝联盟跳转地址 请求失败, adzoneId: {}, relationId: {} promotionSceneId: {} ",
                    adzoneId, relationId, promotionSceneId, e);
        }

        return null;
    }

    /**
     * 创建淘口令
     * @param url 跳转的url地址
     * @param logUrl 图标地址
     * @param text 显示文案
     * @return 生成的淘口令
     */
    public String createTaoWord(String url, String logUrl, String text) {
        try {
            ResponseJson<String> responseJson = commodityInfoFeignService
                    .createTaoWord(url, logUrl, text);

            if (Objects.nonNull(responseJson) && responseJson.success()) {
                return responseJson.getResult();
            }

        } catch(Exception e) {
            log.error("创建淘口令 请求失败, url: {}, logUrl: {}, text: {}", url, logUrl, text, e);
        }

        return "";
    }

}
