/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.market.integration;

import com.bxm.localnews.market.facade.MessageSmsFeignService;
import com.bxm.localnews.market.facade.fallback.MessageSmsFallbackFactory;
import com.bxm.localnews.mq.common.model.dto.SendSmsResult;
import com.bxm.localnews.mq.common.model.dto.SmsSupplyDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author jieliGG
 * @date 2020/9/10 18:03
 **/
@Component
@Slf4j
public class MessageSmsIntegrationService {

    @Autowired
    private MessageSmsFeignService messageSmsFeignService;

    /**
     * 发送自定义短信
     * @param smsSupplyDTO ： content 和phone 必传
     * @return
     */
    public SendSmsResult sendSmsByCustomize(SmsSupplyDTO smsSupplyDTO) {
        return messageSmsFeignService.sendSmsByCustomize(smsSupplyDTO);
    }
}