package com.bxm.localnews.market.integration;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.msg.sender.MessageSender;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.uuid.SequenceCreater;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author zhaoyadong 2019/3/1 10:11
 * @desc
 */
@Slf4j
@Service
@AllArgsConstructor
public class MessageUserIntegrationService extends BaseService {

    private final MessageSender messageSender;

    private final SequenceCreater sequenceCreater;

    /**
     * 推送消息
     *
     * @param message message
     */
    public void pushMsg(PushMessage message) {
        if (log.isDebugEnabled()) {
            log.debug("推送消息: {}", JSON.toJSONString(message));
        }
        try {
            messageSender.sendPushMessage(message);
        } catch (Exception e) {
            log.error("推送消息: {}失败", JSON.toJSONString(message), e);
        }

    }

    /**
     * 发送跟单成功推送
     *
     * @param content 推送内容
     * @param userId  用户id
     */
    public void pushOrderCommissionCheckMsg(String content, Long userId) {
        PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.JUMP_TYPE);
        info.setMsgId(sequenceCreater.nextLongId());
        // 跳转我的订单
        info.setProtocol("wst://mine/billingDetail");

        PushMessage message = PushMessage.build();
        message.setTitle("佣金入账通知");
        message.setContent(content);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle(userId));
        message.setPayloadInfo(info);

        if (log.isDebugEnabled()) {
            log.debug("发送跟单成功推送: {}", JSON.toJSONString(message));
        }

        pushMsg(message);
    }

}
