package com.bxm.localnews.market.integration;

import com.bxm.localnews.market.dto.PaymentOrderInfoDTO;
import com.bxm.localnews.market.facade.PaymentInfoFeignService;
import com.bxm.localnews.market.model.dto.PaymentOrderDTO;
import com.bxm.localnews.market.model.param.order.UserOrderParam;
import com.bxm.localnews.market.param.RefundParam;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author jieliGG
 * @date : 2020年9月3日 11:13:50
 */
@Component
public class PaymentInfoIntegrationService {

    @Autowired
    private PaymentInfoFeignService paymentInfoFeignService;

    /**
     * 创建订单
     * @param param
     * @return
     */
    public PaymentOrderDTO orderCreate(UserOrderParam param) {
        return paymentInfoFeignService.orderCreate(param).getResult();
    }

    /**
     * 创建订单
     * @param refundParam ： 退单参数
     * @return ： 退单结果
     */
    public Message refund(RefundParam refundParam){
        return paymentInfoFeignService.refund(refundParam).getResult();
    }

    /**
     * 根据订单号获取流水明细
     * @param orderSn ： 订单好
     * @return
     */
    public PaymentOrderInfoDTO getPaymentNumByOrderSn(String orderSn){
        return paymentInfoFeignService.getPaymentNumByOrderSn(orderSn).getBody();
    }
}
