package com.bxm.localnews.market.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

import java.math.BigDecimal;

@Data
@Builder
@ApiModel(value = "获取平台佣金请求参数")
public class GetPlatformCommissionParam {

    @ApiModelProperty(value = "商品id", required = true)
    private Long goodsId;

    @ApiModelProperty(value = "三方佣金金额", required = true)
    private BigDecimal commissionPrice;

    @ApiModelProperty(value = "商品支付价格", required = true)
    private BigDecimal payPrice;

    @ApiModelProperty(value = "商品数量", required = true)
    private Long goodsNum;

    @ApiModelProperty(value = "是否是自购单", required = true)
    private Boolean purchaseBySelf;

    @ApiModelProperty(value = "购买人id", required = true)
    private Long userId;

    @ApiModelProperty(value = "购买人是否vip", required = true)
    private Boolean vip;

    @ApiModelProperty(value = "购买人上级id", required = true)
    private Long superiorUserId;

    @ApiModelProperty(value = "业务主体 FOSSICKER: 趣淘金 LOCAL_NEWS: 万事通", required = true)
    private String srcApp;

}
