/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.market.param;

import com.bxm.localnews.enums.MerchantBossAccountActionEnum;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author jieliGG
 * @date 2020/8/27 10:35
 * 操作商家账户的bean
 **/
@Data
public class OperatorMerchantAccountParam {

    private Long userId;

    private Long merchantId;

    /**
     * 订单号
     */
    private String orderSn;

    /**
     * 关联的ID
     */
    private Long relationId;

    /**
     * 关联内容（目前只有订单）
     */
    private String relationTitle;

    /**
     * 提现金额
     */
    private BigDecimal amount;

    /**
     * 用户实际支付金额
     */
    private BigDecimal payMoney;

    /**
     * 用户实际到账金额
     */
    private BigDecimal receiveMoney;

    /**
     * 手续费
     */
    private BigDecimal serviceMoney;

    /**
     * 商家推广费用（佣金）
     */
    private BigDecimal promotionMoney;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 资金变动  动作类型
     */
    private MerchantBossAccountActionEnum actionEnum;
}
