package com.bxm.localnews.market.model;

import com.bxm.newidea.component.vo.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author liujia
 * @date 2020-09-28 20:26
 **/
@Data
@ApiModel(description = "订单退款的相关请求参数")
public class RefundOrderParam extends BasicParam {

    @ApiModelProperty("订单编号")
    private String orderNo;

    @ApiModelProperty(value = "子订单编号 如果该字段不为空 则orderNo为父订单编号", hidden = true)
    private List<String> subOrderNos;

    @ApiModelProperty("发起退款的用户ID")
    private Long userId;

    @ApiModelProperty(value = "是否来源于管理后台", hidden = true)
    private boolean fromAdmin;

}
