/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.market.model.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author jieliGG
 * @date 2020/8/20 22:13
 * 用户购买商户订单的参数
 **/
@Data
public class BuyMerchantOrderDTO {

    @ApiModelProperty("实际支付金额")
    private BigDecimal payPrice;

    @ApiModelProperty("核销码")
    private Long verificationCode;

    @ApiModelProperty("核销码状态 新版定义: 0-已全部核销, 1-可核销, 2-核销码错误; 老版定义: 0-已核销 1-未核销 2-核销码错误")
    private Integer verificationState;

    @ApiModelProperty("订单编号")
    private String orderNo;

    @ApiModelProperty("下单时间")
    private String createTime;

    @ApiModelProperty("付款时间")
    private String payTime;

    @ApiModelProperty("买家姓名")
    private String name;

    @ApiModelProperty("买家手机号")
    private String phone;

    @ApiModelProperty("是否是VIP  0-不是 1-是")
    private Integer isVip;

    @ApiModelProperty("商品名称")
    private String goodsName;

    @ApiModelProperty("商品图片")
    private String goodsImg;

    @ApiModelProperty("购买数量-总数量")
    private Long num;

    @ApiModelProperty("【3.11.0新增】可核销数量")
    private Integer ableVerificationNum;

    @ApiModelProperty("商品的vip优惠价格")
    private BigDecimal vipPrice;

    @ApiModelProperty("商品合计总价")
    private BigDecimal totalPrice;

    @ApiModelProperty("订单类型 0-团购订单")
    private Integer orderType;

    @ApiModelProperty("使用优惠卷的减免金额")
    private BigDecimal couponDiscount;

}
