package com.bxm.localnews.market.model.dto;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 365卡券订单DTO
 *
 * @author wzy
 * @date 2020/8/5 9:13
 **/
@Data
public class CardCouponOrderDTO {
    /**
     * 错误码
     */
    private Integer code;
    /**
     * 错误信息
     */
    private String message;
    /**
     * 订单信息列表
     */
    private List<Order> data;

    @Data
    public static class Order {
        /**
         * 会员昵称
         */
        private String nickName;
        /**
         * 品牌名称
         */
        private String typeName;
        /**
         * 产品名称
         */
        private String commodityName;
        /**
         * 佣金
         */
        private BigDecimal agentRebate;
        /**
         * 订单流水号
         */
        private String sellOrderNo;
        /**
         * 订单创建时间
         */
        private String createTime;
        /**
         * 交易完成时间
         */
        private String completeTime;
        /**
         * 差额
         */
        private BigDecimal diffBalance;
        /**
         * 订单类型，RETURN：返点；WITHDRAW：提现；SALES_MARGIN：销售差额；
         */
        private String capitalType;
        /**
         * 用户唯一识别码
         */
        private String openid;
        /**
         * 支付金额
         */
        private BigDecimal amount;
        /**
         * 官方售价
         */
        private BigDecimal officialPrice;
        /**
         * 订单状态，SOLD：出售成功；SUCCESS：
         * 交易成功；REFUNDED：已退款；AFTER_SALE：售后中；
         */
        private String orderStatus;
    }
}
