package com.bxm.localnews.market.model.dto;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * KFC在线点餐订单DTO
 *
 * @author wzy
 * @date 2020/8/5 17:11
 **/
@Data
public class KfcOrderDTO {

    /**
     * 请求是否成功
     */
    private Boolean success;
    /**
     * 错误码
     */
    private Integer code;
    /**
     * 错误信息
     */
    private String message;
    /**
     * 订单数据列表
     */
    private List<Order> data;

    @Data
    public static class Order {
        /**
         * 创建时间
         */
        private String createTime;
        /**
         * 最后更新时间
         */
        private String updateTime;
        /**
         * 用户id
         */
        private Integer userId;
        /**
         * 订单号
         */
        private String orderNo;
        /**
         * 订单状态 0:待付款 5:排队中 15:TRAN_SUCCESS:交易成功 -5:已取消
         */
        private Integer status;
        /**
         * 状态描述
         */
        private String statusDesc;
        /**
         * 单价(元)
         */
        private BigDecimal unitPrice;

        /**
         * 总价（元）
         */
        private BigDecimal totalPrice;

        /**
         * 支付方式
         * 1：微信支付
         * 2：支付宝支付
         * 10：平台备用金
         */
        private Integer payType;

        /**
         * 支付时间
         */
        private String paymentTime;
        /**
         * 支付金额
         */
        private BigDecimal amount;
        /**
         * 数量
         */
        private String quantity;

        /**
         * 出票时间
         */
        private String drawTime;

        /**
         * 取餐码
         */
        private String ticket;

        /**
         * 用户备注
         */
        private String userRemark;

        /**
         * 佣金（元），此字段在交易完成时才会有值
         */
        private BigDecimal commissionPrice;

        /**
         * 用户手机号码
         */
        private String userMobile;

        /**
         * 取消时间
         */
        private String cancelTime;

        /**
         * 用户昵称
         */
        private String userName;

        /**
         * 退款金额（元）
         */
        private BigDecimal refundPrice;

        /**
         * 平台用户唯一标识
         */
        private String platformUniqueId;

        /**
         * 下单信息
         */
        private KfcPlaceOrder kfcPlaceOrder;

        @Data
        public static class KfcPlaceOrder {
            /**
             * 城市名称
             */
            private String cityName;
            /**
             * 餐厅名称
             */
            private String storeName;
            /**
             * 餐厅地址
             */
            private String storeAddress;

            /**
             * 1:堂食 2:外带 3：外卖
             */
            private Integer eatType;

            /**
             * 餐品明细
             */
            private List<Item> items;

            @Data
            public static class Item {
                /**
                 * 商品id
                 */
                private String productId;

                /**
                 * 商品名称
                 */
                private String productName;

                /**
                 * 数量
                 */
                private Integer quantity;

                /**
                 * 价格（元）
                 */
                private BigDecimal price;

                /**
                 * 图片地址
                 */
                private String imageUrl;

                /**
                 * 是否已取消
                 */
                private Boolean canceled;
            }
        }

        /**
         * 下单手机后4位（非用户手机号）
         */
        private String kfcOrderMobileSuffix;

        /**
         * 下单手机备注
         */
        private String kfcOrderMobileRemark;

        /**
         * 是否外卖
         */
        private Boolean takeout;

        /**
         * 配送费(元)
         */
        private Double takeoutPrice;
    }
}
