/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.market.model.dto;

import lombok.Data;

import java.math.BigDecimal;

/**
 * 商户商品信息
 *
 * @author jieliGG
 * @date 2020/8/25 17:33
 **/
@Data
public class MerchantGoodsInfoDTO {

    private Long merchantId;

    private Long goodsId;
    /**
     * 商品名称
     */
    private String goodsName;
    /**
     * 商品图片
     */
    private String goodsImg;

    /**
     * 是否开启vip折扣  0-否 1-是
     */
    private Integer vipDiscount;

    /**
     * 原价
     */
    private BigDecimal originalPrice;

    /**
     * 商品单价
     */
    private BigDecimal price;

    /**
     * 商铺名称
     */
    private String merchantName;

    /**
     * 商品分类类型
     */
    private Integer goodsCategory;

    /**
     * 是否支持退款
     */
    private Boolean supportRefund;

    /**
     * 销售模式
     * 0: 到店（默认）
     * 1: 邮寄
     */
    private Integer saleModel;

    /**
     * 是否需要身份证号填写
     * 0: 不需要（默认）
     * 1: 需要
     */
    private Integer idNumFlag;
    /**
     * 支持的最大购买数量
     */
    private Integer maxSaleNum;
}
