package com.bxm.localnews.market.model.entity;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.market.model.vo.OrderGroupInfoExtData;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @see OrderGroupInfo
 *
 * @author gonzo
 * @date 2020-12-14 17:23
 **/
@Data
public class GroupOrderInfo extends OrderBaseInfo {

    private Long id;

    /**
     * 商家id
     */
    private Long merchantId;

    /**
     * 规格id 默认为0则无规格信息
     */
    private Long specsId;

    /**
     * 商家名称
     */
    private String merchantName;

    /**
     * 原本支付金额=商品现价 * 个数 * VIP折扣(如果是VIP的话)
     */
    private BigDecimal originalPayPrice;

    /**
     * 使用优惠券实际节省的金额 因为优惠券可能大于支付金额，所以该字段记录实际节省金额
     */
    private BigDecimal couponSavePrice;

    /**
     * 该笔团购订单产生的总佣金
     */
    private BigDecimal totalCommission;

    /**
     * 用户优惠券ID
     */
    private Long userCouponId;

    /**
     * 开通vip花费的金额【可能存在同时开通VIP】
     */
    private BigDecimal openVip;

    /**
     * 商品的核销码
     */
    private Long verificationCode;

    /**
     * 用户名
     */
    private String ownerUserName;

    /**
     * 用户手机号
     */
    private String ownerUserPhone;

    /**
     * 下单场景 0: app下单; 1: 站外下单
     */
    private Byte placeScene;

    /**
     * 物流状态 0：无状态 1：代发货 2：已发货 3：已签收
     */
    private Byte expressStatus;

    /**
     * 子订单数量 默认为0，标识当前订单为非多订单or子订单 否则标识当前父订单下的子订单数量
     */
    private Integer subOrderNum;


    /**
     * 子订单的状态合集标志位 记录当前父订单包含的子订单有哪些状态
     */
    private Long subOrderStatusMark;

    /**
     * 拓展数据，具体字段代码中为准
     */
    private String extData;

    /**
     * 核销时间
     */
    private Date verificationTime;

    /**
     * 申请退单时间
     */
    private Date refundTime;

    /**
     * 支付时间
     */
    private Date payTime;

    private Date createTime;

    private Date modifyTime;

    // 下面是自定义数据


    public OrderGroupInfoExtData getExtDataObj() {
        return StringUtils.isBlank(extData) ? new OrderGroupInfoExtData() : JSON.parseObject(extData, OrderGroupInfoExtData.class);
    }




}