package com.bxm.localnews.market.model.entity;

import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * @author gonzo
 * @date 2020-12-16 20:00
 **/
@Data
public class OrderBaseInfo {
    private Long id;

    /**
     * 商品ID
     */
    private String goodsId;

    /**
     * 商品标题
     */
    private String goodsName;

    /**
     * 商品首图
     */
    private String imgUrl;

    /**
     * 订单号
     */
    private String orderSn;

    /**
     * 父订单号
     */
    private String orderParentSn;

    /**
     * 商品单价
     */
    private BigDecimal goodsPrice;

    /**
     * 商品购买数量
     */
    private Integer goodsNum;

    /**
     * 实际支付金额
     */
    private BigDecimal realPayPrice;

    /**
     * 订单状态  淘客/佣金订单(0: 待结算   1: 已结算   2: 失效) 团购订单(3: 待支付; 6: 支付成功; 7: 消费成功; 8: 退款中; 9: 失效)
     */
    private Integer orderStatus;

    /**
     * 订单子状态 该字段是对order_status的拓展，针对某个order_status的二级状态 具体看代码枚举定义
     */
    private Integer subStatus;

    /**
     * 订单类型 TMALL: 天猫; TAOBAO: 淘宝; JUHUASUAN: 聚划算; ELE: 饿了么; MEITUAN: 美团; TAOQUAN365: 淘券365卡券; OIL_GROUP: 团油; QIANZHU_KFC: 千猪KFC; WANSHITONG_ONE: 万事通商家单人订单; WST_MEMBER_DAY: 万事通5折会员日订单; WST_DISCOUNT_GROUP: 万事通优惠团购订单; WST_ONE_COMMI: 订单的佣金订单; PDD: 拼多多订单
     */
    private String orderType;

    /**
     * 订单场景类型
     * 0: 佣金订单（淘客、外卖） 1: 实物订单（万事通团购、团油、肯德基等等）
     */
    private Byte orderSceneType;

    /**
     * 订单优惠券金额
     */
    private BigDecimal coupon;

    /**
     * 订单所属人id
     */
    private Long userId;

    /**
     * 记录生成时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date modifyTime;
}