package com.bxm.localnews.market.model.entity;

import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * @author gonzo
 * @date 2020-12-19 13:34
 **/
@Data
public class OrderCommissionInfo {
    private Long id;

    /**
     * purchase:自购；share:分享收益
     */
    private String orderProfitType;

    /**
     * 订单的源数据
     */
    private String sourceStr;

    /**
     * pid
     */
    private String pid;

    private String relationId;

    private String specialId;

    /**
     * 来源（目前淘宝）订单创建时间
     */
    private Date sourceOrderCreateTime;

    /**
     * 来源（目前淘宝）订单结算时间
     */
    private Date sourceOrderEarningTime;

    /**
     * 来源（目前淘宝）订单状态3：订单结算，12：订单付款， 13：订单失效，14：订单成功
     */
    private Integer sourceOwnerOrderStatus;

    /**
     * 总佣金  /元
     */
    private BigDecimal commission;

    /**
     * 自购返利佣金/元
     */
    private BigDecimal purchaseCommission;

    /**
     * 上级返利佣金/元
     */
    private BigDecimal parentCommission;

    /**
     * 上上级返利佣金/元
     */
    private BigDecimal grandparentCommission;

    /**
     * 淘客场景订单场景类型，1:常规订单，2:渠道订单，3:会员运营订单
     */
    private Integer type;

    /**
     * 返佣用户类型 0: 普通用户; 1:小达人; 2:中达人; 3:大达人; 4:VIP用户;
     */
    private Byte rebateUserType;

    private Date createTime;

    private Date modifyTime;
}