package com.bxm.localnews.market.model.entity;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * t_order_extend_info
 * @author 
 */
@Data
public class OrderExtendInfoBean implements Serializable {
    private Long id;

    /**
     * t_order_info id
     */
    private Long tOrderInfoId;

    /**
     * 订单所属人id
     */
    private Long ownerUserId;

    /**
     * 订单类型 0 默认类型（就是一些暂未区分出来的统一类型）1 vip0元购订单 2 新人首单返佣订单 3 自定义返佣订单
     */
    private Byte type;

    /**
     * vip0元购助力状态 0 助力中 1 助力成功 2 助力失败 如果是vip0元购类型 则当前字段才有意义
     */
    private Byte vipZeroHelpStatus;

    /**
     * vip0元购助力用户id 如果是vip0元购类型 则当前字段才有意义
     */
    private Long vipZeroHelpUserId;

    /**
     * vip0元购助力截止时间
     */
    private Date vipZeroHelpExpireTime;

    /**
     * 拓展信息 json字段 根据不同业务字段内的值有不同含义
     */
    private String extendJson;

    private Date createTime;

    private Date modifyTime;

    private static final long serialVersionUID = 1L;
}