package com.bxm.localnews.market.model.entity;

import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * @author gonzo
 * @date 2021-01-22 15:37
 **/
@Data
public class OrderGroupHistory {
    private Long id;

    /**
     * 订单号
     */
    private String orderSn;

    /**
     * 商品ID
     */
    private String goodsId;

    /**
     * 商品标题
     */
    private String goodsName;

    /**
     * 商品首图
     */
    private String imgUrl;

    /**
     * 商品单价
     */
    private BigDecimal goodsPrice;

    /**
     * 商品购买数量
     */
    private Long goodsNum;

    /**
     * 实际支付金额
     */
    private BigDecimal realPayPrice;

    /**
     * 使用优惠券实际节省的金额 因为优惠券可能大于支付金额，所以该字段记录实际节省金额
     */
    private BigDecimal couponSavePrice;

    /**
     * 订单状态  淘客/佣金订单(0: 待结算   1: 已结算   2: 失效) 团购订单(3: 待支付; 6: 支付成功; 7: 消费成功; 8: 退款中; 9: 失效)
     */
    private Integer previousOrderStatus;

    /**
     * 订单状态  淘客/佣金订单(0: 待结算   1: 已结算   2: 失效) 团购订单(3: 待支付; 6: 支付成功; 7: 消费成功; 8: 退款中; 9: 失效)
     */
    private Integer currentOrderStatus;

    private Integer previousSubStatus;

    private Integer currentSubStatus;

    /**
     * 订单优惠券金额
     */
    private BigDecimal coupon;

    /**
     * 操作人id
     */
    private Long operatorUserId;

    /**
     * 拓展数据，具体字段代码中为准
     */
    private String extData;

    /**
     * 记录生成时间
     */
    private Date createTime;
}