package com.bxm.localnews.market.model.entity;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * t_order_info
 *
 * @author
 */
@Data
public class OrderInfo1 implements Serializable {
    private Long id;

    /**
     * 商品ID
     */
    private String goodsId;

    /**
     * 商品标题
     */
    private String goodsName;

    /**
     * 商品首图
     */
    private String imgUrl;

    private String relationId;

    private String specialId;

    /**
     * 淘宝订单号（标识不同产品，每个产品一个子订单号，可做为一比订单的唯一标识）
     */
    private String orderSn;

    /**
     * 父订单号（相同产品不同规格的统一标识）
     */
    private String orderParentSn;

    /**
     * 商品单价
     */
    private BigDecimal goodsPrice;

    /**
     * 商品数量
     */
    private Long goodsNum;

    /**
     * 订单最终收入金额
     */
    private BigDecimal payPrice;

    /**
     * 用户实际支付金额
     */
    private BigDecimal userActualPayPrice;

    /**
     * 来源（目前淘宝）订单创建时间
     */
    private Date sourceOrderCreateTime;

    /**
     * 来源（目前淘宝）订单结算时间
     */
    private Date sourceOrderEarningTime;

    /**
     * 订单状态  0：待结算   1：已结算   2：失效
     */
    private Integer orderStatus;

    /**
     * 来源（目前淘宝）订单状态3：订单结算，12：订单付款， 13：订单失效，14：订单成功
     */
    private Integer sourceOwnerOrderStatus;

    /**
     * 佣金  /元
     */
    private BigDecimal commission;

    /**
     * vip自购返佣
     */
    private BigDecimal vipPurchaseCommission;

    /**
     * 自购返利佣金/元
     */
    private BigDecimal purchaseCommission;

    /**
     * 上级返利佣金/元
     */
    private BigDecimal parentCommission;

    /**
     * 上上级返利佣金/元
     */
    private BigDecimal grandparentCommission;

    /**
     * 来源  TB:淘宝 MEITUAN:美团
     */
    private String source;

    /**
     * 订单所属平台类型，包括天猫、淘宝、聚划算等
     * 美团
     */
    private String tbOrderType;

    /**
     * pid
     */
    private String pid;

    /**
     * 场景订单场景类型，1:常规订单，2:渠道订单，3:会员运营订单
     */
    private Integer type;

    /**
     * 订单类型 1: 购物订单 2:外卖, 3:365卡券，4：团油，5：KFC
     */
    private Integer orderType;

    /**
     * 订单优惠券金额
     */
    private BigDecimal coupon;

    /**
     * 使用的优惠券ID
     */
    private Long userCouponId;

    /**
     * 订单所属人id 根据relation id获取到的
     */
    private Long ownerUserId;

    /**
     * 订单的源数据
     */
    private String sourceStr;

    /**
     * 记录生成时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date modifyTime;

    /**
     * 核销码
     */
    private Long verificationCode;

    /**
     * 开通vip花了多少钱
     */
    private BigDecimal openVip;

    /**
     * 用户名
     */
    private String ownerUserName;

    /**
     * 用户手机
     */
    private String ownerUserPhone;

    /**
     * 订单返利类型（PURCHASE自购，SHARE分享）
     */
    private String orderProfitType;

    /**
     * 订单场景类型：：订单场景类型\n0: 佣金订单（淘客、外卖） 1: 实物订单（万事通团购、团油、肯德基等等）'
     */
    private Integer orderSceneType;


    private static final long serialVersionUID = 1L;
}