package com.bxm.localnews.market.model.entity;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author gonzo
 * @date 2020-12-19 14:55
 **/
@Data
public class OrderProfit {
    private static final long serialVersionUID = 1L;

    private Long id;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 订单表id
     */
    private Long orderId;

    /**
     * 商品id
     */
    private String goodsId;

    /**
     * purchase:自购；parent:上级返利；grandParent:上上级返利；share:分享收益
     */
    private String type;

    /**
     * 订单号
     */
    private String orderSn;

    /**
     * 当为返利收益时记录订单发起者信息
     */
    private Long orderOwnerUserId;

    /**
     * 订单状态 0: 待结算   1：已结算   2：失效
     */
    private Integer orderStatus;

    /**
     * 收益金额/分
     */
    private BigDecimal profitAmount;

    /**
     * 收益比例 0.5即为 50% 改字段从1.7.0之后开始赋值
     */
    private BigDecimal profitRate;

    /**
     * 收益冻结状态 0: 未冻结; 1: 待升级;
     */
    private Byte freeze;

    private Date createTime;

    private Date modifyTime;
}