package com.bxm.localnews.market.model.entity;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 包含了团购订单和佣金订单的总字段
 *
 * @author gonzo
 * @date 2020-12-16 20:00
 **/
@Data
public class OrderProfitTotalInfo extends OrderBaseInfo {

    private Long id;

    /**
     * purchase:自购；share:分享收益
     */
    private String orderProfitType;

    /**
     * 订单的源数据
     */
    private String sourceStr;

    /**
     * pid
     */
    private String pid;

    private String relationId;

    private String specialId;

    /**
     * 来源（目前淘宝）订单创建时间
     */
    private Date sourceOrderCreateTime;

    /**
     * 来源（目前淘宝）订单结算时间
     */
    private Date sourceOrderEarningTime;

    /**
     * 来源（目前淘宝）订单状态3：订单结算，12：订单付款， 13：订单失效，14：订单成功
     */
    private Integer sourceOwnerOrderStatus;

    /**
     * 总佣金  /元
     */
    private BigDecimal commission;

    /**
     * 自购返利佣金/元
     */
    private BigDecimal purchaseCommission;

    /**
     * 上级返利佣金/元
     */
    private BigDecimal parentCommission;

    /**
     * 上上级返利佣金/元
     */
    private BigDecimal grandparentCommission;

    /**
     * 淘客场景订单场景类型，1:常规订单，2:渠道订单，3:会员运营订单
     */
    private Integer type;

    /**
     * 返佣用户类型 0: 普通用户; 1:小达人; 2:中达人; 3:大达人; 4:VIP用户;
     */
    private Byte rebateUserType;

    private Date createTime;

    private Date modifyTime;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 订单表id
     */
    private Long orderId;

    /**
     * 商品id
     */
    private String goodsId;

    /**
     * purchase:自购；parent:上级返利；grandParent:上上级返利；share:分享收益
     * profit表的profit type
     */
    private String profitType;

    /**
     * 订单号
     */
    private String orderSn;

    /**
     * 当为返利收益时记录订单发起者信息
     */
    private Long orderOwnerUserId;

    /**
     * 订单状态 0: 待结算   1：已结算   2：失效
     */
    private Integer orderStatus;

    /**
     * 收益金额/分
     */
    private BigDecimal profitAmount;

    /**
     * 收益比例 0.5即为 50% 改字段从1.7.0之后开始赋值
     */
    private BigDecimal profitRate;

}