package com.bxm.localnews.market.model.entity;

import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
  * 
  * @author gonzo
  * @date 2020-12-14 17:24
  **/
@Data
public class TOrderGroupHistory {
    private Long id;

    /**
    * 订单号
    */
    private String orderSn;

    /**
    * 商品ID
    */
    private String goodsId;

    /**
    * 商品标题
    */
    private String goodsName;

    /**
    * 商品首图
    */
    private String imgUrl;

    /**
    * 商品单价
    */
    private BigDecimal goodsPrice;

    /**
    * 商品购买数量
    */
    private Long goodsNum;

    /**
    * 实际支付金额
    */
    private BigDecimal realPayPrice;

    /**
    * 订单状态  淘客/佣金订单(0: 待结算   1: 已结算   2: 失效) 团购订单(3: 待支付; 6: 支付成功; 7: 消费成功; 8: 退款中; 9: 失效)
    */
    private Integer previousOrderStatus;

    /**
    * 订单状态  淘客/佣金订单(0: 待结算   1: 已结算   2: 失效) 团购订单(3: 待支付; 6: 支付成功; 7: 消费成功; 8: 退款中; 9: 失效)
    */
    private Integer currentOrderStatus;

    /**
    * 订单优惠券金额
    */
    private BigDecimal coupon;

    /**
    * 记录生成时间
    */
    private Date createTime;
}