package com.bxm.localnews.market.model.enums;

/**
 * @author gonzo
 * @date 2021-01-15 16:53
 **/
public enum ExpressStatusEnum {

    /**
     * 无
     */
    NONE(0),

    /**
     * 待发货
     */
    WAIT_DELIVER(1),

    /**
     * 待收货
     */
    DELIVERED(2),

    /**
     * 已收货
     */
    DELIVERY_FINISH(3),
    ;

    private byte status;

    ExpressStatusEnum(int status) {
        this.status = (byte) status;
    }


    public byte getStatus() {
        return status;
    }
}
