package com.bxm.localnews.market.model.enums;

/**
 * 商品分佣类型枚举
 *
 * @author wzy
 * @date 2020年11月28日17:32:29
 */
public enum GoodsCommissionTypeEnum {

    /**
     * 按比率分佣
     */
    RATE(0, "按比率分佣"),

    /**
     * 按金额分佣
     */
    AMOUNT(1, "按金额分佣");


    GoodsCommissionTypeEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    /**
     * code
     */
    private Integer code;

    /**
     * 描述
     */
    private String msg;

    public Integer getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
}
