package com.bxm.localnews.market.model.enums;

import lombok.Getter;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * 团油订单状态枚举
 *
 * @author wzy
 * @date 2020/8/8 16:04
 **/
@Getter
public enum OilGroupOrderStatusEnum {
    /**
     * 已支付
     */
    HAS_PAYMENT(1, "已支付"),
    /**
     * 退款申请中
     */
    REFUND_APPLYING(4, "退款申请中"),

    /**
     * 已经退款
     */
    HAS_REFUND(5, "已经退款"),

    /**
     * 退款失败
     */
    REFUND_FAIL(6, "退款失败");

    /**
     * 状态码
     */
    private Integer code;

    /**
     * 描述信息
     */
    private String description;

    OilGroupOrderStatusEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public static OilGroupOrderStatusEnum of(String description) {
        Objects.requireNonNull(description);
        return Stream.of(values()).filter(bean -> bean.description.equals(description))
                .findAny()
                .orElseThrow(() -> new IllegalArgumentException(description + " is not exist"));
    }

    /**
     * 根据code获取具体枚举信息
     *
     * @param code code类型
     * @return 枚举信息
     */
    public static OilGroupOrderStatusEnum of(Integer code) {
        Objects.requireNonNull(code);
        return Stream.of(values()).filter(bean -> bean.code.equals(code))
                .findAny()
                .orElseThrow(() -> new IllegalArgumentException(code + " is not exist"));
    }
}
