package com.bxm.localnews.market.model.enums;

/**
 * @author gonzo
 * @date 2020-12-17 19:49
 **/
public enum OrderPushEnum {

    /**
     *
     */
    PLACE_ORDER_TO_MERCHANT("用户下单通知", "用户%s刚刚下单了商品%s"),

    PAY_ORDER_TO_MERCHANT("用户付费订单", "用户%s刚刚付费购买了商品%s"),

    PAY_ORDER_TO_USER("购买商品成功通知", "恭喜你购买成功（%s），分享商品给好友可获得分佣哦~"),

    CONSUME_SUCCESS_TO_MERCHANT("用户核销成功", "用户%s已核销成功商品(%s)"),

    REFUND_TO_MERCHANT("用户申请退款", "用户%s申请退款（商品%s），请及时处理，超过5天未处理，系统自动退款"),

    REFUND_SUCCESS_TO_USER("退款提醒", "您申请的退款（%s），已到账，请注意查收~"),

    REFUND_REFUSE_TO_USER("商家拒绝退款", "商家拒绝你申请的退款（%s），如有疑问请联系商家或万事通客服花花"),


    MY_SHARE_COMMISSION_TO_USER("佣金入账通知", "您的好友购买了商品，您获得了%s元佣金，分享越多收益越多哦~~"),

    MY_COMMISSION_TO_USER("佣金入账通知", "您有一笔自购佣金%s元已到账，购买平台所有商品都可以获得返佣哦~"),


    PARENT_COMMISSION_TO_USER("佣金入账通知", "您有一笔团队收益%s元已到账，发展达人越多赚的越多哦~"),
    ;


    private String title;

    private String content;

    OrderPushEnum(String title, String content) {
        this.title = title;
        this.content = content;
    }

    public String getTitle() {
        return title;
    }

    public String getContent() {
        return content;
    }
}
