package com.bxm.localnews.market.model.enums;

/**
 * 订单场景类型枚举
 *
 * @author wzy
 * @version 1.0
 * @date 2020/11/28 8:30 下午
 */
public enum OrderSceneTypeEnum {

    /**
     * 分佣订单
     */
    COMMISSION(0, "分佣订单"),
    /**
     * 实物订单
     */
    ACTUAL(1, "实物订单");

    OrderSceneTypeEnum(int code, String description) {
        this.code = (byte) code;
        this.description = description;
    }

    /**
     * code
     */
    private byte code;

    /**
     * 描述
     */
    private String description;

    public byte getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }
}