package com.bxm.localnews.market.model.enums;

import java.util.Arrays;

/**
 * @author gonzo
 * @date 2020-12-17 20:54
 **/
public enum OrderStatusAllEnum {
    /**
     * 待结算
     */
    UNSETTLED(0, "待结算"),
    /**
     * 已结算
     */
    HAVE_SETTLED(1, "已结算"),
    /**
     * 已失效
     */
    INVALID(2, "已失效"),
    /**
     * 待支付
     */
    UNPAY(3, "待支付"),
    /**
     * 支付成功
     */
    SUCCESS_PAY(6, "成功支付"),
    /**
     * 核销成功
     */
    VERIFICATION_PAY(7, "核销成功"),
    /**
     * 退单中
     */
    REFUNDING(8, "退单中"),
    /**
     * 退单成功
     */
    REFUND_SUCCESS(9, "退单成功"),

    ;


    OrderStatusAllEnum(Integer status, String description) {
        this.status = status;
        this.description = description;
    }

    /**
     * 订单状态
     */
    private Integer status;

    /**
     * 描述
     */
    private String description;

    public static OrderStatusAllEnum getByStatus(int status) {
        return Arrays.stream(OrderStatusAllEnum.values()).filter(p -> p.status == status).findAny().orElse(null);
    }

    public Integer getStatus() {
        return status;
    }

    public String getDescription() {
        return description;
    }
}
