package com.bxm.localnews.market.model.enums;

/**
 * 订单tab表示各个标签的值(和客户端的订单列表对应)
 * 我的订单：0 全部，1待结算，2已结算，3失效，4待付款，5待使用，6退款/售后
 * 团队订单：0 全部，1待结算，2已结算
 *
 * @author wzy
 * @date 2020年09月09日14:53:51
 */
public enum OrderTabItem {
    /**
     * 全部
     */
    ALL(0, "全部"),
    /**
     * 待结算
     */
    UNSETTLED(1, "待结算"),
    /**
     * 已结算
     */
    HAVE_SETTLED(2, "已结算"),
    /**
     * 已失效
     */
    INVALID(3, "已失效"),
    /**
     * 待支付
     */
    WAIT_PAY(4, "待支付"),
    /**
     * 待使用
     */
    WAIT_USE(5, "待使用"),
    /**
     * 待使用
     */
    REFUND(6, "退款/售后");
    /**
     * code
     */
    private int code;
    /**
     * 描述信息
     */
    private String description;

    OrderTabItem(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
