package com.bxm.localnews.market.model.enums;

import lombok.Getter;

import static com.bxm.localnews.market.model.enums.OrderSceneTypeEnum.ACTUAL;
import static com.bxm.localnews.market.model.enums.OrderSceneTypeEnum.COMMISSION;

/**
 * 订单表tb_order_status订单状态枚举
 *
 * @author wzy
 * @date 2020/8/6 9:56
 * <p>
 * 字段说明：t_order_info
 * source：字段是来源，如TB，天猫、淘宝、聚划算、饿了么都属于TB
 * order_type：是订单类型就是枚举中code，如1
 * order_scene_type：订单场景类型\n0: 佣金订单（淘客、外卖） 1: 实物订单（万事通团购、团油、肯德基等等）'
 **/
@Getter
public enum OrderTypeEnum {
    /**
     * 天猫
     */
    TMALL(1, COMMISSION),

    /**
     * 淘宝
     */
    TAOBAO(1, COMMISSION),

    /**
     * 聚划算
     */
    JUHUASUAN(1, COMMISSION),

    /**
     * 饿了么
     */
    ELE(2, COMMISSION),

    /**
     * 美团
     */
    MEITUAN(2, COMMISSION),

    /**
     * 淘券365卡券
     */
    TAOQUAN365(3, ACTUAL),

    /**
     * 团油
     */
    OIL_GROUP(4, ACTUAL),

    /**
     * 千猪KFC
     */
    QIANZHU_KFC(5, ACTUAL),


    /**
     * 万事通商家卖的商品 单人购买订单【3.6.0】
     * 下个版本可能有团购订单，所以这里叫做单人订单
     */
    WANSHITONG_ONE(6, ACTUAL),

    /**
     * 万事通5折会员日订单
     */
    WST_MEMBER_DAY(6, ACTUAL),

    /**
     * 万事通优惠团购订单
     */
    WST_DISCOUNT_GROUP(6, ACTUAL),

    /**
     * 订单的佣金订单
     */
    WST_ONE_COMMI(7, COMMISSION),

    /**
     * 拼多多订单
     */
    PDD(8, COMMISSION),

    /**
     * vip
     */
    VIP(9, ACTUAL),
    ;


    /**
     * 订单状态编码
     */
    private int orderType;

    private OrderSceneTypeEnum orderSceneType;

    OrderTypeEnum(int orderType, OrderSceneTypeEnum orderSceneType) {
        this.orderType = orderType;
        this.orderSceneType = orderSceneType;
    }

    public byte getOrderSceneType() {
        return orderSceneType.getCode();
    }
}
