package com.bxm.localnews.market.model.param;

import com.bxm.newidea.component.vo.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @author gonzo
 * @date 2020-12-10 15:12
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "确认订单，唤起支付请求参数")
public class ConfirmOrderParam extends BasicParam {

    @ApiModelProperty(value = "用户id", required = true)
    @NotNull(message = "用户id不能为null")
    private Long userId;

    @ApiModelProperty(value = "订单号", required = true)
    private String orderNo;

    @ApiModelProperty(value = "商品id", required = true)
    @NotNull(message = "商品id不能为null")
    private Long goodsId;

    @ApiModelProperty(value = "下单个数 默认1个", required = true)
    private int num = 1;

    @ApiModelProperty(value = "是否开通vip - 0-不开通 1-开通", required = true)
    private Integer openVip;

    @ApiModelProperty("用户姓名 : 站内需要传userId，站外这个必传")
    private String userName;

    @ApiModelProperty("手机号 : 站内需要传userId，站外这个必传")
    private String userPhone;

    @ApiModelProperty("创建订单使用的优惠卷ID，数据来自：11-14-06、11-14-07")
    private Long userCouponId;

    @ApiModelProperty(value = "支付方式,1:微信支付，2：支付宝支付，3：微信JS-API支付", allowableValues = "1,2,3", required = true)
    @NotNull(message = "请选择支付方式")
    private Byte payType;

    @ApiModelProperty("微信code，微信jsapi支付时需要提供")
    private String wechatCode;

    @ApiModelProperty("支付成功后的跳转地址")
    private String returnUrl;

    @ApiModelProperty(value = "支付金额")
    private BigDecimal amount;

    @ApiModelProperty(value = "请求来源IP", hidden = true)
    private String requestIp;

    @ApiModelProperty(value = "商品的分享人id, 站外下单的时候传入", hidden = true)
    private Long shareUserId;

    @ApiModelProperty(value = "【3.10.1】收货详细地址 如果是邮寄商品则需要填写")
    private String address;

    @ApiModelProperty(value = "【3.10.1】收货地址省市区 如果是邮寄商品则需要填写")
    private String provinceAddr;

    @ApiModelProperty(value = "【3.10.1】收货地址编码 如果是邮寄商品则需要填写")
    private String areaCodeAddr;

    @ApiModelProperty(value = "【3.10.1】身份证号")
    private String idNum;

    @ApiModelProperty(value = "【3.11.0新增】规格id 如果商品无规格则不传", required = false)
    private Long specsId;
}
