package com.bxm.localnews.market.model.param;

import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;

/**
 * @author wzy
 * @date 2020年09月01日20:10:39
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "团队订单分页查询参数")
public class GroupOrderParam extends PageParam {

    @ApiModelProperty(value = "用户ID", required = true)
    private Long userId;

    @ApiModelProperty(value = "查询类型 0:全部，1：待结算|2：已结算|3：失效")
    private Integer queryType;
}
