package com.bxm.localnews.market.model.param;

import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@ApiModel(description = "我的订单分页查询参数")
@EqualsAndHashCode(callSuper = true)
public class MyOrderParam extends PageParam {
    private static final long serialVersionUID = -4139913611948755338L;
    @ApiModelProperty(value = "用户ID", required = true)
    private Long userId;

    @ApiModelProperty(value = "查询类型 0：全部，1：待结算|2：已结算|3：失效 4:待付款 5：待使用 6：退款/售后")
    private Integer queryType;

    @ApiModelProperty(
            value = "通用参数：当前APP的上线版本",
            required = true
    )
    private String curVer;
}
