package com.bxm.localnews.market.model.param;

import com.bxm.newidea.component.vo.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotEmpty;

/**
 * @author gonzo
 * @date 2020-12-10 16:51
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "订单简略信息请求参数")
public class OrderSummaryParam extends BasicParam {

    @ApiModelProperty(value = "订单号", required = true)
    @NotEmpty(message = "订单号不能为空")
    private String orderNo;

    @ApiModelProperty(value = "用户id", required = true)
    private Long userId;

}
