package com.bxm.localnews.market.model.param;

import com.bxm.newidea.component.vo.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;

/**
 * @author gonzo
 * @date 2020-12-10 15:12
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "用户准备下单，生成订单信息请求参数")
public class PrepareOrderParam extends BasicParam {

    @ApiModelProperty(value = "商品id", required = true)
    @NotNull(message = "商品id不能为null")
    private Long goodsId;

    @ApiModelProperty(value = "用户id", required = true)
    @NotNull(message = "用户id不能为null")
    private Long userId;

    @ApiModelProperty(value = "【3.11.0新增】 下单个数 默认1个", required = true)
    private int num = 1;

    @ApiModelProperty(value = "【3.11.0新增】 规格id 如果商品无规格则不传", required = false)
    private Long specsId;

    @ApiModelProperty(value = "订单号 如果是从订单列表调过来的 则携带订单号即可", required = false)
    private String orderNo;

}
