package com.bxm.localnews.market.model.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author gonzo
 * @date 2020-12-10 15:12
 **/
@Data
@ApiModel(description = "处理退款订单")
public class RefundOptionOrderParam {

    @ApiModelProperty(value = "订单号", required = true)
    private String orderNo;

    @ApiModelProperty(value = "处理结果（历史遗留原因定义成这个名字）, 0: 拒绝退款; 1: 手动允许退款; 2: 自动退款", required = true)
    private Integer result;

    @ApiModelProperty(value = "操作人id 网关层注入", required = true, hidden = true)
    private Long currentUserId;

    @ApiModelProperty("商家id")
    private Long merchantId;

    @ApiModelProperty(value = "是否来源于管理后台", hidden = true)
    private boolean fromAdmin;

}
