package com.bxm.localnews.market.model.param.order;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "商户购买权益订单参数")
@Data
public class UserBuyGoodsOrderParam extends UserOrderParam {

    @ApiModelProperty(value = "商品id", required = true)
    private Long goodsId;

    @ApiModelProperty(value = "是否开通vip - 0-不开通 1-开通", required = true)
    private Integer openVip;

    @ApiModelProperty("用户姓名 : 站内需要传userId，站外这个必传")
    private String userName;

    @ApiModelProperty("手机号 : 站内需要传userId，站外这个必传")
    private String userPhone;

    @ApiModelProperty("订单号 : 继续支付的时候需要使用")
    private String orderNo;

    @ApiModelProperty("创建订单使用的优惠卷ID，数据来自：11-14-06、11-14-07")
    private Long userCouponId;
}

