package com.bxm.localnews.market.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author gonzo
 * @date 2020-12-10 15:52
 **/
@Data
@ApiModel(description = "确认订单的唤起支付返回参数")
public class ConfirmOrderResult {

    @ApiModelProperty(value = "付款链接")
    private String link;

    @ApiModelProperty(value = "付款订单编号，可根据此订单编号查询支付状态")
    private String paymentNum;

    @ApiModelProperty(value = "当前支付对应的appid，js-api特有参数")
    private String appId;

    @ApiModelProperty(value = "时间戳参数，js-api特有参数")
    private String timeStamp;

    @ApiModelProperty(value = "随机码，js-api特有参数")
    private String nonceStr;

    @ApiModelProperty(value = "js-api特有参数")
    private String packageValue;

    @ApiModelProperty(value = "签名类型，js-api特有参数")
    private String signType;

    @ApiModelProperty(value = "支付签名，js-api特有参数")
    private String paySign;

    @ApiModelProperty("是否开通vip : 0-没有开通 1-开通")
    private Integer openVip;

    @ApiModelProperty("订单号，和paymentNum不同，功能是用来插订单核销码信息")
    private String orderNo;

    @ApiModelProperty("0: 正常下单，1：直接支付成功，其他: 异常下单")
    private int code;

    @ApiModelProperty("异常情况下的错误")
    private String errorMsg;
}
