package com.bxm.localnews.market.model.vo;

import com.bxm.localnews.market.model.entity.GroupOrderInfo;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 *
 * @see GroupOrderInfo
 *
 * @author gonzo
 * @date 2020-12-18 15:08
 **/
@Data
public class GroupOrderInfoFacadeVO {

    private Long id;

    /**
     * 商品ID
     */
    private String goodsId;

    /**
     * 商品标题
     */
    private String goodsName;

    /**
     * 商品首图
     */
    private String imgUrl;

    /**
     * 订单号
     */
    private String orderSn;

    /**
     * 父订单号
     */
    private String orderParentSn;

    /**
     * 商品单价
     */
    private BigDecimal goodsPrice;

    /**
     * 商品购买数量
     */
    private Integer goodsNum;

    /**
     * 实际支付金额
     */
    private BigDecimal realPayPrice;

    /**
     * 订单状态  淘客/佣金订单(0: 待结算   1: 已结算   2: 失效) 团购订单(3: 待支付; 6: 支付成功; 7: 消费成功; 8: 退款中; 9: 失效)
     */
    private Integer orderStatus;

    /**
     * 订单子状态 该字段是对order_status的拓展，针对某个order_status的二级状态 具体看代码枚举定义
     */
    private Integer subStatus;

    /**
     * 订单类型 TMALL: 天猫; TAOBAO: 淘宝; JUHUASUAN: 聚划算; ELE: 饿了么; MEITUAN: 美团; TAOQUAN365: 淘券365卡券; OIL_GROUP: 团油; QIANZHU_KFC: 千猪KFC; WANSHITONG_ONE: 万事通商家单人订单; WST_MEMBER_DAY: 万事通5折会员日订单; WST_DISCOUNT_GROUP: 万事通优惠团购订单; WST_ONE_COMMI: 订单的佣金订单; PDD: 拼多多订单
     */
    private String orderType;

    /**
     * 订单场景类型
     * 0: 佣金订单（淘客、外卖） 1: 实物订单（万事通团购、团油、肯德基等等）
     */
    private Byte orderSceneType;

    /**
     * 订单优惠券金额
     */
    private BigDecimal coupon;

    /**
     * 订单所属人id
     */
    private Long userId;

    /**
     * 记录生成时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date modifyTime;

    /**
     * 商家id
     */
    private Long merchantId;

    /**
     * 商家名称
     */
    private String merchantName;

    /**
     * 原本支付金额=商品现价 * 个数 * VIP折扣(如果是VIP的话)
     */
    private BigDecimal originalPayPrice;

    /**
     * 使用优惠券实际节省的金额 因为优惠券可能大于支付金额，所以该字段记录实际节省金额
     */
    private BigDecimal couponSavePrice;

    /**
     * 该笔团购订单产生的总佣金
     */
    private BigDecimal totalCommission;

    /**
     * 用户优惠券ID
     */
    private Long userCouponId;

    /**
     * 开通vip花费的金额【可能存在同时开通VIP】
     */
    private BigDecimal openVip;

    /**
     * 商品的核销码
     */
    private Long verificationCode;

    /**
     * 用户名
     */
    private String ownerUserName;

    /**
     * 用户手机号
     */
    private String ownerUserPhone;

    /**
     * 下单场景 0: app下单; 1: 站外下单
     */
    private Byte placeScene;


    /**
     * 拓展数据，具体字段代码中为准
     */
    private String extData;

    /**
     * 核销时间
     */
    private Date verificationTime;

    /**
     * 申请退单时间
     */
    private Date refundTime;

    /**
     * 支付时间
     */
    private Date payTime;

    /**
     * 物流状态 0：无状态 1：代发货 2：已发货 3：已签收
     */
    private Byte expressStatus;
}
