package com.bxm.localnews.market.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author gonzo
 * @date 2020-12-10 17:23
 **/
@Data
@ApiModel(description = "团购订单信息")
public class GroupPurchaseOrder {

    @ApiModelProperty("订单号")
    private String orderSn;

    @ApiModelProperty("商品名称")
    private String goodsName;

    @ApiModelProperty("商品id")
    private String goodsId;

    @ApiModelProperty("商品首图")
    private String goodsFirstImg;

    @ApiModelProperty("订单创建时间")
    private Date sourceOrderCreateTime;

    @ApiModelProperty("实际支付金额 单位元")
    private BigDecimal payPrice;

    @ApiModelProperty("订单状态  2：已失效 3:待支付 4：超时未支付 5：取消支付 6:成功支付 7:核销成功 8:退单中 9:退单成功 10:拒绝退单待核销")
    private Integer orderStatus;

    @ApiModelProperty("商品优惠券")
    private BigDecimal coupon;

    @ApiModelProperty("订单数量")
    private Integer num;

    @ApiModelProperty(value = "是否支持退款0: 不支持; 1: 支持")
    private Integer supportRefund;

    @ApiModelProperty(value = "商户id")
    private Long merchantId;

}
