package com.bxm.localnews.market.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 团油订单详情VO
 *
 * @author wzy
 * @date 2020年09月01日
 */
@Data
@ApiModel(description = "团油订单详情")
public class OilGroupOrderDetailVO {

    @ApiModelProperty(value = "交易单号", example = "如：ZH0000014472008111jm601")
    private String orderId;

    @ApiModelProperty(value = "加油站名称", example = "留下加油站")
    private String gasName;

    @ApiModelProperty(value = "地址", example = "浙江省杭州市西湖区三墩镇xx加油站")
    private String address;

    @ApiModelProperty(value = "油号", example = "95#")
    private String oilNo;

    @ApiModelProperty(value = "枪号", example = "13")
    private Integer gunNo;

    @ApiModelProperty(value = "油枪金额", example = "100.00")
    private String amountGun;

    @ApiModelProperty(value = "加油升数", example = "16.7")
    private String litre;

    @ApiModelProperty(value = "团油优惠", example = "5.98")
    private String amountDiscounts;

    @ApiModelProperty(value = "优惠券金额", example = "2.2")
    private String couponMoney;

    @ApiModelProperty(value = "支付方式", example = "微信支付")
    private String payType;

    @ApiModelProperty(value = "实付金额", example = "94.2")
    private String amountPay;

    @ApiModelProperty(value = "下单时间", example = "2020-09-01 15:45:55")
    private String orderTime;

    @ApiModelProperty(value = "订单状态", example = "已取消")
    private String orderStatus;
}
