package com.bxm.localnews.market.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author gonzo
 * @date 2020-12-10 16:47
 **/
@Data
@ApiModel(description = "订单详情")
public class OrderDetailInfo {

    @ApiModelProperty(value = "商家信息", required = true)
    private MerchantInfoSimpleVO merchantInfo;

    @ApiModelProperty(value = "商品名称", required = true)
    private String goodsName;

    @ApiModelProperty(value = "父核销码", required = true)
    private String verificationCode;

    @ApiModelProperty(value = "订单号", required = true)
    private String orderNo;

    @ApiModelProperty("手机号")
    private String userPhone;

    @ApiModelProperty(value = "下单时间", required = true)
    private String createTime;

    @ApiModelProperty(value = "商品购买个数", required = true)
    private Integer goodsNum;

    @ApiModelProperty(value = "订单总价", required = true)
    private BigDecimal totalPrice;

    @ApiModelProperty(value = "红包金额", required = true)
    private BigDecimal couponPrice;

    @ApiModelProperty("实付金额")
    private BigDecimal payPrice;

    @ApiModelProperty("订单状态  3:待支付 6:成功支付 7:核销成功 8:退单中 9:退单成功(已失效)")
    private Integer orderStatus;

    @ApiModelProperty(value = "是否支持退款0: 不支持; 1: 支持")
    private Integer supportRefund;

    @ApiModelProperty("【3.10.1】物流状态 0：无状态（到店使用订单） 1：代发货 2：已发货 3：已签收")
    private Byte expressStatus;

    @ApiModelProperty("【3.10.1】物流信息 当expressStatus非0时才有意义")
    private ExpressInfo expressInfo;

    @ApiModelProperty(value = "【3.11.0新增】可用数量")
    private Integer ableUseNum;

    @ApiModelProperty(value = "【3.11.0新增】多个核销码信息", required = true)
    private List<VerificationCodeInfo> verificationCodeInfos;

    @ApiModelProperty(value = "【3.11.0新增】多地址数量 1以上则展示多地址", required = true)
    private Integer addrInfoNum;

    @ApiModelProperty(value = "【3.11.0新增】商品id", required = true)
    private String goodsId;

}
