package com.bxm.localnews.market.model.vo;

import com.bxm.localnews.market.model.param.ConfirmOrderParam;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author gonzo
 * @date 2020-12-16 15:07
 **/
@Data
public class OrderGroupInfoExtData {

    /**
     * 第三方收取服务费
     */
    private BigDecimal serviceMoney;

    /**
     * 商家推广费用[佣金]
     */
    private BigDecimal promotionMoney;

    /**
     * 商家实际到账金额
     */
    private BigDecimal receiveMoney;

    /**
     * 下单的请求参数
     */
    private ConfirmOrderParam placeOrderParam;

    /**
     * 小达人佣金
     */
    private BigDecimal smallTalentCommission;

    /**
     * 小达人佣金比例
     */
    private BigDecimal smallTalentRate;

    /**
     * 中达人佣金
     */
    private BigDecimal midTalentCommission;

    /**
     * 小达人佣金比例
     */
    private BigDecimal midTalentRate;

    /**
     * 大达人佣金
     */
    private BigDecimal bigTalentCommission;

    /**
     * 大达人佣金比例
     */
    private BigDecimal bigTalentRate;

    /**
     * 上级佣金
     */
    private BigDecimal parentCommission;

    /**
     * 上级佣金比例
     */
    private BigDecimal parentRate;

    /**
     * 上上级佣金
     */
    private BigDecimal grandparentCommission;

    /**
     * 上上级佣金比例
     */
    private BigDecimal grandparentRate;

    /**
     * 总佣金
     */
    private BigDecimal totalCommission;

    /**
     * 上上级佣金比例
     */
    private BigDecimal totalRate;

    /**
     * 是否VIP
     */
    private Boolean isVip;

    /**
     * VIP用户购买商品时的折扣比例
     *
     */
    private BigDecimal vipRebate;

    /**
     * 商户手续费率
     */
    private BigDecimal serviceRate;

    /**
     * 是否支持退款
     */
    private Boolean supportRefund;

    /**
     * VIP折扣
     */
    private Boolean vipDiscount;

    /**
     * 商品销售模式
     * 0: 到店（默认）
     * 1: 邮寄
     */
    private Integer goodsSaleModel;


    /**
     * 物流信息
     */
    private ExpressInfo expressInfo;

    /**
     * 身份证号
     */
    private String idNum;
}
