package com.bxm.localnews.market.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author gonzo
 * @date 2020-12-10 16:47
 **/
@Data
@ApiModel(description = "订单简略信息")
public class OrderSummaryInfo {

    @ApiModelProperty(value = "核销码", required = true)
    private String verificationCode;

    @ApiModelProperty(value = "订单号", required = true)
    private String orderNo;

    @ApiModelProperty(value = "商品名称", required = true)
    private String goodsName;

    @ApiModelProperty("用户姓名 : 站内需要传userId，站外这个必传")
    private String userName;

    @ApiModelProperty("手机号 : 站内需要传userId，站外这个必传")
    private String userPhone;

    @ApiModelProperty("实付金额")
    private BigDecimal payPrice;

    @ApiModelProperty("关注公众号状态 0：未关注 1：已关注")
    private Integer subscribeStatus;

    @ApiModelProperty("关注商家状态 0：未关注 1：已关注")
    private Integer merchantFollowStatus;
}
