package com.bxm.localnews.market.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author gonzo
 * @date 2020-12-10 15:22
 **/
@Data
@ApiModel(description = "确认订单信息返回参数")
public class PrepareOrderVO {

    @ApiModelProperty(value = "订单号 如果是去付款，则会返回订单号供去付款时提供", required = true)
    private String orderNo;

    @ApiModelProperty(value = "购买人姓名", required = false)
    private String nickName;

    @ApiModelProperty(value = "购买人手机号", required = false)
    private String mobile;

    @ApiModelProperty(value = "商品名称", required = true)
    private String goodsName;

    @ApiModelProperty(value = "商品首图", required = true)
    private String goodsImg;

    @ApiModelProperty(value = "购买个数 如果用户无购买次数，则返回0 前端需要提示超出最大购买数", required = true)
    private Integer num;

    @ApiModelProperty(value = "【3.11.0新增】最大购买个数 如果为0 则表示无法购买", required = true)
    private Integer maxNum;

    @ApiModelProperty(value = "商品原价", required = true)
    private BigDecimal originalPrice;

    @ApiModelProperty(value = "商品现价", required = true)
    private BigDecimal normalPrice;

    @ApiModelProperty(value = "VIP折扣价", required = true)
    private BigDecimal vipPrice;

    @ApiModelProperty(value = "vip开通需要的金额", required = true)
    private BigDecimal vipOpenPrice;

    @ApiModelProperty(value = "【3.11.0已失效】开通vip立减金额，因为数量可以选择，转而使用VIP折扣字段前端自己计算", required = true)
    @Deprecated
    private BigDecimal vipDisCountPrice;

    @ApiModelProperty(value = "是否是VIP商品 0-否 1-是", required = true)
    private Integer vipDiscount;

    @ApiModelProperty(value = "选择的优惠券id", required = true)
    private Long couponId;

    @ApiModelProperty(value = "选择的优惠券金额", required = true)
    private BigDecimal couponPrice;

    @ApiModelProperty(value = "是否开通VIP 0: 否; 1: 是", required = true)
    private Integer openVip;

    @ApiModelProperty(value = "订单支付价格（重复确认时会携带，表示的是上一笔订单确认之后的支付价格）", required = true)
    private BigDecimal orderPrice;

    @ApiModelProperty(value = "商户id", required = true)
    private Long merchantId;

    @ApiModelProperty(value = "商户名称", required = true)
    private String merchantName;

    @ApiModelProperty(value = "【3.10.1】销售模式 0: 到店（默认）; 1: 邮寄（需要填写收货地址）", required = true)
    private Integer saleModel;

    @ApiModelProperty("【3.10.1】收货详细地址 重复确认订单时返回")
    private String address;

    @ApiModelProperty(value = "【3.10.1】收货地址省市区 如果是邮寄商品则需要填写 重复确认订单时返回")
    private String provinceAddr;

    @ApiModelProperty(value = "【3.10.1】收货地址编码 如果是邮寄商品则需要填写 重复确认订单时返回")
    private String areaCodeAddr;

    @ApiModelProperty(value = "【3.10.1】是否需要身份证号填写 0: 不需要（默认）; 1: 需要 ")
    private Integer idNumFlag;

    @ApiModelProperty(value = "【3.11.0新增】开通vip立减的比例 使用该字段计算可以省多少钱", required = true)
    private BigDecimal vipDisCountRate;

    @ApiModelProperty(value = "【3.11.0新增】 规格id 如果商品无规格则不传", required = false)
    private Long specsId;
}
