package com.bxm.localnews.market.model.vo;

import com.bxm.localnews.market.model.enums.OrderExtendType;
import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;

/**
 * Created by Gonzo on 2019-07-23.
 */
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "金币提现详情")
@Data
@Builder
public class UserOrderInfoVO extends BaseBean {

    private static final long serialVersionUID = 3723767966620932959L;
    @ApiModelProperty("订单号")
    private String orderSn;

    @ApiModelProperty("商品名称")
    private String goodsName;

    @ApiModelProperty("商品id")
    private String goodsId;

    @ApiModelProperty("商品首图")
    private String goodsFirstImg;

    @ApiModelProperty("订单创建时间")
    private Date sourceOrderCreateTime;

    @ApiModelProperty("实际支付金额 单位元")
    private BigDecimal payPrice;

    @ApiModelProperty("佣金 单位元")
    private BigDecimal commission;

    @ApiModelProperty("订单类型")
    private String orderTypeName;

    @ApiModelProperty("订单来源 TB：淘宝")
    private String source;

    @ApiModelProperty("订单状态  0：待结算|1：已结算|2：已失效 3:待支付 4：超时未支付 5：取消支付 6:成功支付 7:核销成功 8:退单中 9:退单成功 10:拒绝退单待核销")
    private Integer orderStatus;

    @ApiModelProperty("好友昵称")
    private String friendNick;

    @ApiModelProperty("好友佣金")
    private BigDecimal friendCommission;

    @ApiModelProperty("好友头像")
    private String imgUrl;

    @ApiModelProperty("商品优惠券")
    private BigDecimal coupon;

    @ApiModelProperty("隐私状态，1:开启，-1:关闭")
    private Integer type;

    @ApiModelProperty("是否好友订单，0-非好友订单，1-好友订单")
    private Integer friendOrder;

    @ApiModelProperty("邀请0元购标签：INVITE_ZERO 、首单福利标签：FIRST_ORDER")
    private String label;

    @ApiModelProperty(value = "订单所属平台类型" +
            "天猫: TMALL、淘宝: TAOBAO、饿了吗: ELE，美团: MEITUAN，淘券365卡券: TAOQUAN365，团油: OIL_GROUP，千猪KFC: QIANZHU_KFC，万事通商家单人订单: WANSHITONG_ONE" +
            "万事通商家单人佣金订单: WST_ONE_COMMI，拼多多订单: PDD",
            example = "TMALL, TAOBAO, ELE, MEITUAN, TAOQUAN365，OIL_GROUP，QIANZHU_KFC，WANSHITONG_ONE")
    private String orderType;

    @ApiModelProperty("订单数量")
    private Integer num;

    /**
     * @see OrderExtendType
     */
    @ApiModelProperty(value = "订单下单类型", example = "订单类型 0 默认类型（就是一些暂未区分出来的统一类型）1 vip0元购订单 2 新人首单返佣订单")
    private Byte orderSubType;

    @ApiModelProperty(value = "第三方订单确认收货跳转地址，目前只有淘宝自购订单", example = "第三方订单跳转地址，如：https://main.m.taobao.com/odetail/index.html?bizOrderId={订单号}&archive=false")
    private String thirdPartyConfirmUrl;

    @ApiModelProperty(value = "查看第三方订单跳转地址，365淘券对应【查看卡券】，KFC对应【查看订单】跳转地址", example = "跳转第三方订单的订单详情页")
    private String thirdPartyFindUrl;

    @ApiModelProperty(value = "是否确认收货，目前只针对淘宝订单", example = "true确认收货，false未确认收货")
    private Boolean confirmReceived;

    @ApiModelProperty(value = "预计结算时间，淘宝自购订单确认收货后才会有这个字段，美团结算时间为订单生成次月25号0点，饿了么结算时间为订单生成次日11点 ",
            example = "如：2020/09/01 16:30")
    private String expectSettlementTime;

    @ApiModelProperty(value = "第三方订单状态")
    private Integer sourceOwnerOrderStatus;

    @ApiModelProperty(value = "订单title")
    private String orderTitle;

    @ApiModelProperty(value = "logo图标地址")
    private String logoUrl;

}
