package com.bxm.localnews.market.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 饿了么的配置信息
 * @Author: Gonzo
 * @Date 2020-02-08 11:32
 */
@Data
@Component
@ConfigurationProperties("market.order.config.ele")
public class EleProperties {

    /**
     * 推广位id
     */
    private Long adZoneId = 110491950272L;

    /**
     * 淘客联盟官方活动id，这里配置为饿了么的活动id
     */
    private Long promotionSceneId = 1571715733668L;

    /**
     * 饿了么淘口令url地址
     */
    private String eleTaoWordImgUrl = "";

    /**
     * 饿了么淘口令url地址
     */
    private String eleTaoWordText = "饿了么淘口令";

    /**
     * 每日凌晨同步前多少天的订单
     * 默认2
     */
    private Integer syncCreateOrderBeforeDays = 3;

    /**
     * 最大已结算，但是又取消次数
     * 默认5次
     */
    private Integer maxCancelTimes = 5;
}
