package com.bxm.localnews.market.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * KFC在线点餐第三方接口配置类
 *
 * @author wzy
 * @date 2020/8/5 15:17
 **/
@Component
@Data
@ConfigurationProperties("order.config.kfc")
public class KfcProperties {
    /**
     * 分页查询订单配置
     * https://live-test.qianzhu8.com 测试
     * https://live.qianzhu8.com 正式
     */
    private String pagedOrderUrl = "https://live.qianzhu8.com/openApi/v1/kfcOrders/pagedQuery";
    /**
     * 平台id
     * 10264 测试
     * 10303 正式
     */
    private Integer platformId = 10303;

    /**
     * 密钥
     * 52j9brvppzu3l1ls 测试
     * nhks85ku3qn9uejh 正式
     */
    private String secret = "nhks85ku3qn9uejh";

    /**
     * 连接超时时间(毫秒)
     */
    private Integer timeout = 10000;

    /**
     * 优惠系数：因为无法获取优惠金额
     * 使用 支付金额 * 优惠系数，来获取省钱金额
     */
    private Double discountCoefficient = 0.25;

    /**
     * 千猪kfc订单详情页跳转地址
     */
    private String detailUrl = "https://kfc-test.qianzhu8.com/order/info";

    /**
     * 获取用户token接口地址
     */
    private String getTokenUrl = "https://live-test.qianzhu8.com/api/v1/platform/getToken";

}
