package com.bxm.localnews.market.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 外卖订单佣金配置信息
 *
 * @Author: Gonzo
 * @date 2020-03-25 15:43
 * @since 1.6.1
 */
@Component
@ConfigurationProperties("market.order.config")
@Data
public class OrderProperties {

    /**
     * 是否强制拉取所有订单
     */
    private Boolean pullAllMeituanOrder = false;


    /**
     * 美团订单拉取的主体
     */
    private String meituanOrderSiteId = "LOCAL_NEWS";

    /**
     * 饿了么图片地址
     */
    private String eleOrderImgUrl = "https://mtest.wstong.com/localnews_test/png/20200528/H8UKWHWUVZ7GVLAT2B3D1COBE67R2DGIHJQAK0.png";

    /**
     * 美团图片地址
     */
    private String meiTuanOrderImgUrl = "https://mtest.wstong.com/localnews_test/png/20200528/H8UKWHWUVZ7GVLAT2B3D1COBE67R2D87IJQAK1.png";
}
