package com.bxm.localnews.market.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;

/**
 * 外卖订单佣金配置信息
 * @Author: Gonzo
 * @date  2020-03-25 15:43
 * @since 1.6.1
 */
@Component
@ConfigurationProperties("market.order.config.take-out")
@Data
public class TakeOutOrderCommissionProperties {

    /**
     * 饿了么返佣
     */
    private Ele ele = new Ele();

    /**
     * 美团返佣
     */
    private MeituanTakeOutOrder meituanTakeOutOrder = new MeituanTakeOutOrder();

    /**
     * 饿了么返佣
     */
    @Data
    public class Ele {

        /**
         * 自购通用佣金比例
         * 相对于支付金额而不是订单的佣金金额
         * 默认4%
         */
        private BigDecimal commonCommissionPurchaseRateForPayPrice = BigDecimal.valueOf(0.04);

        /**
         * vip自购佣金比例
         * 相对于支付金额而不是订单的佣金金额
         * 默认4% 和普通自购价格一致
         */
        private BigDecimal vipPurchaseRateForPayPrice = BigDecimal.valueOf(0.4);

        /**
         * 上级通用佣金比例
         * 相对于支付金额而不是订单的佣金金额
         * 默认0
         */
        private BigDecimal commonCommissionRateParentForPayPrice = BigDecimal.ZERO;

        /**
         * 上上级通用佣金比例
         * 相对于支付金额而不是订单的佣金金额
         * 默认0
         */
        private BigDecimal commonCommissionRateGrandParentForPayPrice = BigDecimal.ZERO;
    }

    /**
     * 美团返佣
     */
    @Data
    public class MeituanTakeOutOrder {

        /**
         * 自购通用佣金比例
         * 相对于支付金额而不是订单的佣金金额
         * 默认4%
         */
        private BigDecimal commonCommissionPurchaseRateForPayPrice = BigDecimal.valueOf(0.04);

        /**
         * vip自购佣金比例
         * 相对于支付金额而不是订单的佣金金额
         * 默认4% 和普通自购价格一致
         */
        private BigDecimal vipPurchaseRateForPayPrice = BigDecimal.valueOf(0.04);

        /**
         * 上级通用佣金比例
         * 相对于支付金额而不是订单的佣金金额
         * 默认0
         */
        private BigDecimal commonCommissionRateParentForPayPrice = BigDecimal.ZERO;

        /**
         * 上上级通用佣金比例
         * 相对于支付金额而不是订单的佣金金额
         * 默认0
         */
        private BigDecimal commonCommissionRateGrandParentForPayPrice = BigDecimal.ZERO;
    }
}
